var $ = jQuery;
$(function() {
    $("input[type=radio][name=days]").on("change", function() {
        var a = $(this).val();
        if (a != "") {
            $("input[type=radio][name=hours]").attr("disabled", false);
            $("div#times .loader").show();
            $("div#times .form-group").hide();
            doAdminAjax(
                {
                    action: "fetchhours",
                    id: a
                },
                function(data) {
                    data = $.parseJSON(data);
                    if (data) {
                        if (data.confirmations !== null) {
                            $("input[type=radio][name=hours]").attr(
                                "disabled",
                                false
                            );
                            $(".btndate").show();

                            $.each(data.reserved, function(key, value) {
                                $(
                                    "input[type=radio][name=hours][value='" +
                                        value +
                                        "']"
                                ).attr("disabled", true);
                            });

                            $.each(data.exceptions, function(key, value) {
                                var res = value.split("-");
                                var start = res[0];
                                var end = res[1];
                                var radioGroup = $(
                                    "input[type=radio][name=hours]"
                                );

                                for (var i = 0; i < radioGroup.length; i++) {
                                    $thisRadio = radioGroup[i];

                                    if (
                                        start <= $thisRadio.value &&
                                        $thisRadio.value < end
                                    ) {
                                        $thisRadio.disabled = true;
                                        $thisRadio.parentNode.style.display =
                                            "none";
                                    }
                                }
                            });
                            $("div#times .loader").hide();
                            $("div#times .form-group").show();
                        }
                        //else
                        //  showErrorMessage(data.error);
                    }
                }
            );
        }
    });

    $(document).on("click", ".show_form", function(e) {
        e.preventDefault();
        var fullname = "";
        var username = $(this).attr("id");
        $("#approve, #disapproval").attr("data-target", username);
        fullname = $(this)
            .parent()
            .parent()
            .find("td:nth-child(2)")
            .text();
        $("div#exampleModalCenter h5.modal-title").text(
            "تایید مدارک :: " + fullname
        );

        $("div#exampleModalCenter textarea").val("");
    });

    $(document).on("click", "#approve, #disapproval", function(e) {
        var id = $(this).attr("data-target");
        var type = $(this).attr("id");
        var text = $("div#exampleModalCenter textarea").val();
        var obj = $("a.show_form#" + id)
            .parent()
            .parent();
        if (type == "disapproval" && text == "") {
            showErrorMessage("لطفا متن اصلاحات را تایپ نمایید");
        } else {
            doAdminAjax(
                {
                    action: "phdcheck",
                    type: type,
                    id: id,
                    text: text
                },
                function(data) {
                    data = $.parseJSON(data);
                    if (data) {
                        if (data.confirmations !== null) {
                            $("a.show_form#" + id).remove();
                            if (type == "approve") {
                                obj.css("background", "darkseagreen");
                            } else {
                                obj.css("background", "lightpink");
                            }
                            $("#exampleModalCenter").modal("toggle");
                        }
                    }
                }
            );
        }
    });

    $(document).on("click", ".show_form2", function(e) {
        e.preventDefault();
        var fullname = "";
        var username = $(this).attr("id");
        $("#register").attr("data-target", username);
        fullname = $(this)
            .parent()
            .parent()
            .find("td:nth-child(2)")
            .text();
        $("div#exampleModalCenter2 h5.modal-title").text(
            "تایید مدارک :: " + fullname
        );
        $("div#exampleModalCenter2 #usern").val("");
        $("div#exampleModalCenter2 #pwd").val("");
    });

    $(document).on("click", "#register", function(e) {
        var id = $(this).attr("data-target");
        var password = $("input#pwd").val();
        var obj = $("a.show_form2#" + id)
            .parent()
            .parent();
        if (password == "") {
            showErrorMessage("لطفا فرم را با دقت تکمیل نمایید");
        } else {
            doAdminAjax(
                {
                    action: "userphd",
                    id: id,
                    p: password
                },
                function(data) {
                    data = $.parseJSON(data);
                    if (data) {
                        if (data.confirmations !== null) {
                            $("a.show_form2#" + id).remove();
                            obj.css("background", "darkseagreen");
                            $("#exampleModalCenter2").modal("toggle");
                        }
                    }
                }
            );
        }
    });

    if ($(".date").length > 0) {
        dateOpt = {
            /*changeYear:true,changeMonth:true,*/
            isRTL: true,
            dateFormat: "yy/mm/dd"
        };
        $(".date").datepicker(dateOpt);
    }
    if ($(".time").length > 0) {
        $(".time")
            .clockpicker({ donetext: "انجام" })
            .find("input")
            .change(function() {});
    }
});
