@section('pagetitle', 'تغییر گذرواژه')
@extends('admin.layouts.master')

@section('content')

<x-alert :messages="$errors->any()?$errors:session()->get('message')" />
<div class="card">
    <div class="card-header align-items-center d-flex">
        <h4 class="card-title mb-0 flex-grow-1">@yield('pagetitle')</h4>
    </div>
    <div class="card-body">
        <form action="{{env('ADMIN_HOME')}}/profile" method="post" enctype="multipart/form-data">
            @csrf
            <div class="mb-3 row">
                <label for="staticEmail" class="col-sm-2 col-form-label">مشخصات کاربر</label>
                <div class="col-sm-10">
                    {{Auth::guard('admin')->user()->username}} / {{Auth::guard('admin')->user()->name}}
                </div>
            </div>

            <div class="mb-3 row">
                <label for="inputPassword" class="col-sm-2 col-form-label">رمز عبور فعلی</label>
                <div class="col-sm-10">
                    <input type="password" name="pwd" class="form-control" id="inputPassword">
                </div>
            </div>
            <div class="mb-3 row">
                <label for="inputPassword1" class="col-sm-2 col-form-label">رمز عبور جدید</label>
                <div class="col-sm-10">
                    <input type="password" name="password" class="form-control" id="inputPassword1">
                    <span style="font-size:12px; color:blueviolet">فرمت رمز عبور جدید؛ بایستی حداقل 6 کاراکتر، شامل اعداد، حروف
                        لاتین کوچک و بزرگ و همچنین کاراکترهای خاص (مانند ! @ # $ % & *)باشد</span>
                </div>
            </div>
            <div class="mb-3 row">
                <label for="inputPassword2" class="col-sm-2 col-form-label">تکرار رمز عبور جدید</label>
                <div class="col-sm-10">
                    <input type="password" name="password_confirmation" class="form-control" id="inputPassword2">
                </div>
            </div>
            <div class="d-grid gap-5 col-4 mx-auto">
                <button class="btn btn-success" type="submit"> تغییر گذرواژه</button>
            </div>
        </form>
    </div>
</div>


@endsection
